package w83b.w83bDAO;


import java.util.HashMap;
import java.util.List;


import w83b.w83bBeans.W83bDocBeanImpug;

import w83b.w83bBeans.W83bDocBean;
import w83b.w83bBeans.W83bImpugnacionBean;
import w83b.w83bBeans.W83bListImpugnacionesBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;





// TODO: Auto-generated Javadoc
/**
 * The Interface W83bIImpugnacionesDAO.
 * @author a
 */
public interface W83bIImpugnacionesDAO {
	
	
	/**
	 * Calcular num impugnacion.
	 *
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String calcularNumImpugnacion(W83bImpugnacionBean param)throws Exception;
	
	/**
	 * Buscar impugnaciones.
	 * 
	 * @param param the param
	 * @return the java.util. list
	 * @throws Exception the exception
	 */
	public java.util.List buscarImpugnaciones(w83b.w83bBeans.W83bImpugnacionBean param)throws Exception;
	
	/**
	 * Contar impugnaciones.
	 * 
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String contarImpugnaciones(w83b.w83bBeans.W83bImpugnacionBean param)throws Exception;
	
	/**
	 * Cargar centro trabajo preaviso.
	 * 
	 * @param param the param
	 * @return the list
	 * @throws Exception the exception
	 */
	public List cargarCentroTrabajoPreaviso(HashMap param)throws Exception;
	
	/**
	 * Cargar centro trabajo acta.
	 * 
	 * @param mapaResultado the mapa resultado
	 * @return the list
	 * @throws Exception the exception
	 */
	public List cargarCentroTrabajoActa(HashMap mapaResultado) throws Exception;
	
	/**
	 * Buscar sindicatos.
	 * 
	 * @param param the param
	 * @return the list
	 * @throws Exception the exception
	 */
	public List buscarSindicatos(w83b.w83bBeans.W83bImpugnacionBean param) throws Exception;
	
	/**
	 * Anyadir sindicatos.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void anyadirSindicatos(W83bImpugnacionBean param) throws Exception;
	
	/**
	 * Anyadir empresa impugnante.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void anyadirEmpresaImpugnante(W83bImpugnacionBean param) throws Exception;
	
	/**
	 * Anyadir tramite.
	 *
	 * @param param the tramite
	 * @param fase the fase
	 * @param tramite the tramite
	 * @throws Exception the exception
	 */
	public void anyadirTramite(W83bImpugnacionBean param, int fase, int tramite,String fechaRegistro) throws Exception;
	
	
	/**
	 * Anyadir voces.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void anyadirVoces(W83bImpugnacionBean param) throws Exception;
	
	/**
	 * Anyadir impugnaciones.
	 * 
	 * @param param the param
	 * @return the w83b impugnacion bean
	 * @throws Exception the exception
	 */
	public W83bImpugnacionBean anyadirImpugnaciones(W83bImpugnacionBean param) throws Exception;

	/**
	 * Anyadir laudo.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void anyadirLaudo(W83bImpugnacionBean param) throws Exception;
	
	/**
	 * Carga tipos documento.
	 * 
	 * @param param the param
	 * @return the list
	 * @throws Exception the exception
	 */
	public List cargaTiposDocumento(HashMap param) throws Exception ;
	
	/**
	 * Adjuntar archivo impugnaciones.
	 * 
	 * @param param the param
	 * @return the string
	 * @throws Exception the exception
	 */
	public String adjuntarArchivoImpugnaciones(HashMap param) throws Exception;
	
	/**
	 * Borrar impugnacion.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarImpugnacion(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar borrarImpugnante.
	 * 
	 * @param param the W83bImpugnacionBean bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarImpugnante(W83bImpugnacionBean param) throws Exception;
	/**
	 * Borrar docs impugnaciones.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarDocsImpugnaciones(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar tramites impugnacion.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarTramitesImpugnacion(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar tramite laudo.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarTramiteLaudo(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar docs impugnaciones.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void borrarDocsImpugnaciones (w83b.w83bBeans.W83bImpugnacionBean  param) throws Exception;
	
	/**
	 * Borrar sindicatos.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarSindicatos(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar laudo.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarLaudo(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar empresa impugnante.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarEmpresaImpugnante(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar voces.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarVoces(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Borrar historial.
	 * 
	 * @param param the param
	 * @param usuarioBean the usuario bean
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean borrarHistorial(String param,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Obtener docs impugnacion.
	 * 
	 * @param codSelec the cod selec
	 * @param idioma the idioma
	 * @return the w83b impugnacion bean
	 * @throws Exception the exception
	 */
	public W83bImpugnacionBean obtenerDocsImpugnacion(String codSelec,String idioma) throws Exception;	
	
	/**
	 * Obtener historial impugnacion.
	 * 
	 * @param codSelec the cod selec
	 * @param idioma the idioma
	 * @return the w83b impugnacion bean
	 * @throws Exception the exception
	 */
	public W83bImpugnacionBean obtenerHistorialImpugnacion(String codSelec,String idioma) throws Exception;
	
	/**
	 * Borrar sindicatos impugnaciones.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void borrarSindicatosImpugnaciones(W83bImpugnacionBean param) throws Exception;
	
	/**
	 * Borrar voces.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void borrarVoces(W83bImpugnacionBean param) throws Exception;
	
	/**
	 * Descargar documento.
	 * 
	 * @param param the param
	 * @return the w83b doc bean impug
	 * @throws Exception the exception
	 */
	public W83bDocBeanImpug descargarDocumento(String param) throws Exception;
	
	/**
	 * Insertar docs impugnaciones.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public String insertarDocsImpugnaciones(W83bImpugnacionBean param) throws Exception;
	
	/**
	 * Obtener datos basicos impugnacion.
	 * 
	 * @param codSelec the cod selec
	 * @param idioma the idioma
	 * @param usuarioBean the usuario bean
	 * @return the w83b impugnacion bean
	 * @throws Exception the exception
	 */
	
	public W83bImpugnacionBean obtenerDatosBasicosImpugnacion(String codSelec,String idioma,W83bUsuarioXLNetsBean usuarioBean) throws Exception;
	
	/**
	 * Obtener tramites impugnacion.
	 *
	 * @param codSelec the idioma
	 * @param idioma the idioma
	 * @return the w83b impugnacion bean
	 * @throws Exception the exception
	 */
	public W83bImpugnacionBean obtenerTramitesImpugnacion(String codSelec,String idioma)	throws Exception;
	
	/**
	 * Existe impugnacion.
	 * 
	 * @param param the param
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean existeImpugnacion(W83bImpugnacionBean param)throws Exception;

	/**
	 * Editar impugnaciones.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void editarImpugnaciones(W83bImpugnacionBean param)throws Exception;
	
	/**
	 * Editar empresa impugnante.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void editarEmpresaImpugnante(W83bImpugnacionBean param)throws Exception;
	
	/**
	 * Editar laudo.
	 * 
	 * @param param the param
	 * @throws Exception the exception
	 */
	public void editarLaudo(W83bImpugnacionBean param)throws Exception;
	
	
	/**
	 * Existe laudo impugnacion.
	 *
	 * @param param the param
	 * @return the w83b list impugnaciones bean
	 * @throws Exception the exception
	 */
	public String existeLaudoImpugnacion(W83bListImpugnacionesBean param) throws Exception;

	/**
	 * Tiene laudo distinto.
	 *
	 * @param param the param
	 * @return true, if successful
	 * @throws Exception the exception
	 */
	public boolean tieneLaudoDistinto(W83bImpugnacionBean param) throws Exception;
	
	/**
	 * Editar obtenerNumImpugnacion.
	 *
	 * @param mapaResultado the mapa resultado
	 * @return the string
	 * @throws Exception the exception
	 */
	public String obtenerNumImpugnacion(HashMap mapaResultado) throws Exception; 
	
	public void editarTramite(W83bImpugnacionBean param, int fase, int tramite) throws Exception;
	
	public boolean existeTramite(W83bImpugnacionBean param,int fase, int tramite)throws Exception;
	
	/**
    * Actualiza la informacin de acuse de recibo de una comunicacin de una impugnacion resueltas
    * @param listaComunicacionesAcuse List
    * @throws Exception the exception
    */
	public void  actualizarDatosAcuseComunicacion(W83bDocBean docBean) throws Exception;
	
}